	function comp = hdlcompiface(name)
	%comp = hdlcompiface(name)
	%
	%Available components: reg, fa, fa_noc, ha, ha_noc, dff
	
	%Copyright 2008, 2010 Anton Blad
	%
	%This file is part of firgen.
	%
	%firgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	%
	%firgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	%
	%You should have received a copy of the GNU General Public License
	%along with firgen.  If not, see <http://www.gnu.org/licenses/>
	
	if strcmp(name, 'reg')
		comp.iface.name = 'reg';
		comp.iface.generics = hdlsignal('wordlength', 2);
		comp.iface.inputs = hdlsignal('d', 1, 'wordlength');
		comp.iface.outputs = hdlsignal('q', 1, 'wordlength');
		comp.arch.class = 0;
	elseif strcmp(name, 'fa')
		comp.iface.name = 'fa';
		comp.iface.generics = [];
		comp.iface.inputs(1) = hdlsignal('in1', 0);
		comp.iface.inputs(2) = hdlsignal('in2', 0);
		comp.iface.inputs(3) = hdlsignal('in3', 0);
		comp.iface.outputs(1) = hdlsignal('outs', 0);
		comp.iface.outputs(2) = hdlsignal('outc', 0);
		comp.iface.globals = [];
		comp.arch.class = 0;
	elseif strcmp(name, 'fa_noc')
		comp.iface.name = 'fa_noc';
		comp.iface.generics = [];
		comp.iface.inputs(1) = hdlsignal('in1', 0);
		comp.iface.inputs(2) = hdlsignal('in2', 0);
		comp.iface.inputs(3) = hdlsignal('in3', 0);
		comp.iface.outputs(1) = hdlsignal('outs', 0);
		comp.iface.globals = [];
		comp.arch.class = 0;
	elseif strcmp(name, 'ha')
		comp.iface.name = 'ha';
		comp.iface.generics = [];
		comp.iface.inputs(1) = hdlsignal('in1', 0);
		comp.iface.inputs(2) = hdlsignal('in2', 0);
		comp.iface.outputs(1) = hdlsignal('outs', 0);
		comp.iface.outputs(2) = hdlsignal('outc', 0);
		comp.iface.globals = [];
		comp.arch.class = 0;
	elseif strcmp(name, 'ha_noc')
		comp.iface.name = 'ha_noc';
		comp.iface.generics = [];
		comp.iface.inputs(1) = hdlsignal('in1', 0);
		comp.iface.inputs(2) = hdlsignal('in2', 0);
		comp.iface.outputs(1) = hdlsignal('outs', 0);
		comp.iface.globals = [];
		comp.arch.class = 0;
	elseif strcmp(name, 'dff')
		comp.iface.name = 'dff';
		comp.iface.generics = [];
		comp.iface.inputs(1) = hdlsignal('d', 0);
		comp.iface.outputs(1) = hdlsignal('q', 0);
		comp.arch.class = 0;
	elseif strcmp(name, 'ucmult')
		comp.iface.name = 'ucmult';
		comp.iface.generics(1) = hdlsignal('win', 2);
		comp.iface.generics(2) = hdlsignal('wout', 2);
		comp.iface.generics(3) = hdlsignal('c', 2);
		comp.iface.inputs = hdlsignal('din', 1, 'win');
		comp.iface.outputs = hdlsignal('dout', 1, 'wout');
		comp.iface.globals = [];
		comp.arch.class = 0;
	elseif strcmp(name, 'uadd')
		comp.iface.name = 'uadd';
		comp.iface.generics(1) = hdlsignal('w', 2);
		comp.iface.inputs(1) = hdlsignal('din1', 1, 'w');
		comp.iface.inputs(2) = hdlsignal('din2', 1, 'w');
		comp.iface.outputs = hdlsignal('dout', 1, 'w');
		comp.iface.globals = [];
		comp.arch.class = 0;
	elseif strcmp(name, 'scmult')
		comp.iface.name = 'scmult';
		comp.iface.generics(1) = hdlsignal('win', 2);
		comp.iface.generics(2) = hdlsignal('wout', 2);
		comp.iface.generics(3) = hdlsignal('c', 2);
		comp.iface.inputs = hdlsignal('din', 1, 'win');
		comp.iface.outputs = hdlsignal('dout', 1, 'wout');
		comp.iface.globals = [];
		comp.arch.class = 0;
	elseif strcmp(name, 'sadd')
		comp.iface.name = 'sadd';
		comp.iface.generics(1) = hdlsignal('w', 2);
		comp.iface.inputs(1) = hdlsignal('din1', 1, 'w');
		comp.iface.inputs(2) = hdlsignal('din2', 1, 'w');
		comp.iface.outputs = hdlsignal('dout', 1, 'w');
		comp.iface.globals = [];
		comp.arch.class = 0;
	elseif strcmp(name, 'clkgen')
		comp.iface.name = 'clkgen';
		comp.iface.generics(1) = hdlsignal('period', 256);
		comp.iface.inputs = [];
		comp.iface.outputs(1) = hdlsignal('clk', 0);
		comp.iface.outputs(2) = hdlsignal('reset', 0);
		comp.iface.globals = [];
		comp.arch.class = 0;
	elseif strcmp(name, 'stimgen')
		comp.iface.name = 'stimgen';
		comp.iface.generics(1) = hdlsignal('stimfn', 257);
		comp.iface.generics(2) = hdlsignal('wordlength', 2);
		comp.iface.inputs = [];
		comp.iface.outputs = hdlsignal('data', 1, 'wordlength');
		comp.arch.class = 0;
	elseif strcmp(name, 'cmp')
		comp.iface.name = 'cmp';
		comp.iface.generics(1) = hdlsignal('wordlength', 2);
		comp.iface.inputs(1) = hdlsignal('x1', 1, 'wordlength');
		comp.iface.inputs(2) = hdlsignal('x2', 1, 'wordlength');
		comp.iface.outputs(1) = hdlsignal('y', 0);
		comp.iface.globals = [];
		comp.arch.class = 0;
	else
		error('hdlcompiface: unknown component %s', name);
	end
	
